# 通知設計書 19-Video brightness

## 概要

本ドキュメントは、FreeBSDカーネルにおけるACPI Video brightness通知の設計を記述する。ACPI映像デバイスの輝度が変更された際にdevctl(4)サブシステムを通じてユーザーランドに通知を送信する仕組みについて定義する。

### 本通知の処理概要

ACPI Video brightness通知は、ACPI映像出力デバイスの輝度設定（_BCM ACPI Method）が実行された際にvo_set_brightness()関数内でdevctl_notifyにより発行されるカーネル通知である。

**業務上の目的・背景**：ノートPCやディスプレイ一体型デバイスでは、ACPIを通じた画面輝度の制御が行われる。輝度変更はキーボードのファンクションキー操作、電源プロファイルの切り替え、ユーザーの手動設定などで発生する。ユーザーランドのOSD（On-Screen Display）表示プログラムやデスクトップ環境の電源管理機能が輝度変更を検知し、ユーザーにフィードバックを提供するために本通知が必要である。

**通知の送信タイミング**：vo_set_brightness()関数内で、ACPI _BCMメソッドによる輝度設定コマンドの発行後に送信される。_BCMの成功・失敗にかかわらず通知は発行される。

**通知の受信者**：devctl(4)デバイスをオープンしているユーザーランドプロセス。主にdevd(8)デーモンやデスクトップ環境の電源管理コンポーネントが受信する。

**通知内容の概要**：システム名「ACPI」、サブシステム名「Video」、タイプ「brightness」、データとして輝度レベル（notify={level}）が通知される。

**期待されるアクション**：ユーザーランドのOSD表示、輝度設定のGUI反映、電源管理ログの記録などを行う。

## 通知種別

カーネルdevctl通知（devctl_notify経由）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（devctl(4)キュー経由） |
| 優先度 | 通常 |
| リトライ | なし |

### 送信先決定ロジック

devctl(4)デバイスファイル(/dev/devctl)をオープンしているすべてのプロセスに対してブロードキャスト送信される。

## 通知テンプレート

### devctl通知の場合

| 項目 | 内容 |
|-----|------|
| システム名 | ACPI |
| サブシステム名 | Video |
| タイプ | brightness |
| データ | notify={輝度レベル} |

### 本文テンプレート

```
!system=ACPI subsystem=Video type=brightness notify={level}
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| level | 輝度レベル（0-100の整数値） | vo_set_brightness()の引数 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| sysctl操作 | hw.acpi.video.lcd0.brightness等のsysctl書き込み | 常に送信 | ユーザーによる輝度設定 |
| 電源プロファイル変更 | acpi_video_power_profile() | 常に送信 | ACまたはバッテリーモード切替時の輝度自動調整 |
| ACPIイベント | acpi_video_notify_handler() | 常に送信 | キーボード輝度キー操作等 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| なし | vo_set_brightness()が呼び出されれば、_BCMの成功・失敗にかかわらず常に通知が発行される |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[vo_set_brightness呼び出し] --> B[ACPI_SERIAL_ASSERT]
    B --> C[acpi_SetInteger _BCM level]
    C --> D{ACPI_FAILURE?}
    D -->|Yes| E[エラーメッセージ出力]
    D -->|No| F[vo->vo_level = level]
    E --> G[notify_buf生成 notify=level]
    F --> G
    G --> H[devctl_notify ACPI/Video/brightness/notify_buf]
    H --> I[終了]
```

## データベース参照・更新仕様

該当なし（カーネル内メモリ構造体の操作のみ）

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| acpi_video_output構造体 | 映像出力デバイス情報 | vo_handle、vo_level、vo_hasbqc等 |

### テーブル別参照項目詳細

#### acpi_video_output構造体

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| handle | ACPIオブジェクトハンドル | _BCMメソッド呼び出し用 |
| vo_level | キャッシュされた輝度レベル | _BCM成功時に更新 |
| vo_hasbqc | _BQCメソッドの存在有無 | 輝度取得方法の判定 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| acpi_video_output構造体 | UPDATE | vo_levelを新しい輝度レベルに更新（_BCM成功時のみ） |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| _BCM実行失敗 | ACPI_FAILUREが返された場合 | printf()でエラーメッセージを出力するが、devctl通知は発行される |
| devctl送信失敗 | devctlキューが満杯 | 通知は破棄される |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし。

## セキュリティ考慮事項

- devctl(4)デバイスへのアクセスにはroot権限が必要
- 輝度レベルは0-100の範囲の整数値であり、機密情報ではない

## 備考

- vo_set_brightness()関数はsys/dev/acpica/acpi_video.cの1174行目に定義されている
- devctl_notify()呼び出しは1188行目で行われる
- notify_bufは16バイトの固定サイズバッファ（1176行目）
- _BCMはACPI仕様のSet Brightness Level Control Methodである
- _BQCはBrightness Query Current Levelメソッドで、輝度の取得に使用される
- ACPI_SERIAL_ASSERT(video_output)により、シリアライズされたアクセスが保証される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ACPI映像出力デバイスの構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | acpi_video.c | `sys/dev/acpica/acpi_video.c` | acpi_video_output構造体（52-72行目: handle、vo_level、vo_hasbqc等） |
| 1-2 | acpi_video.c | `sys/dev/acpica/acpi_video.c` | acpi_video_softc構造体（76-84行目: device、handle、vid_outputs等） |

**読解のコツ**: acpi_video_outputはSTAILQリンクリストで管理される個々の映像出力デバイスを表す。vo_levelは_BQCメソッドが利用できない場合のキャッシュとして使用される。

#### Step 2: エントリーポイントを理解する

vo_set_brightness()が輝度設定とdevctl通知の中心関数である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | acpi_video.c | `sys/dev/acpica/acpi_video.c` | vo_set_brightness()関数（1174-1189行目） |

**主要処理フロー**:
1. **1179行目**: ACPI_SERIAL_ASSERT(video_output)でシリアライゼーション確認
2. **1180行目**: acpi_SetInteger(vo->handle, "_BCM", level)でACPIメソッド呼び出し
3. **1181-1183行目**: ACPI_FAILURE時のエラーメッセージ出力
4. **1185行目**: vo->vo_level = level（_BCM成功時のみ）
5. **1187行目**: notify_buf生成（"notify=%d"フォーマット）
6. **1188行目**: devctl_notify("ACPI", "Video", "brightness", notify_buf)

#### Step 3: 呼び出し元を理解する

vo_set_brightness()がどのような操作から呼び出されるかを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | acpi_video.c | `sys/dev/acpica/acpi_video.c` | acpi_video_vo_active_sysctl() - sysctlハンドラ |
| 3-2 | acpi_video.c | `sys/dev/acpica/acpi_video.c` | acpi_video_power_profile() - 電源プロファイル変更 |
| 3-3 | acpi_video.c | `sys/dev/acpica/acpi_video.c` | acpi_video_notify_handler() - ACPIイベントハンドラ |

### プログラム呼び出し階層図

```
[輝度変更トリガー]
    |
    +-- sysctl hw.acpi.video.lcd0.brightness
    |      +-- acpi_video_vo_active_sysctl()
    |
    +-- 電源プロファイル変更（AC/Battery）
    |      +-- acpi_video_power_profile()
    |
    +-- キーボード輝度キー（ACPI Notify）
    |      +-- acpi_video_notify_handler()
    |
    +-- vo_set_brightness() [sys/dev/acpica/acpi_video.c:1174]
           |
           +-- acpi_SetInteger("_BCM", level)
           +-- devctl_notify("ACPI", "Video", "brightness", notify_buf)
```

### データフロー図

```
[入力]                       [処理]                          [出力]

acpi_video_output  --->  vo_set_brightness()         --->  devctl(4)キュー
level (0-100)            |                              |
                         +-- _BCMメソッド実行            +-- devd(8)
                         +-- vo_level更新               +-- デスクトップ環境
                         +-- devctl_notify
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| acpi_video.c | `sys/dev/acpica/acpi_video.c` | ソース | vo_set_brightness()の実装、devctl_notify呼び出し |
| acpivar.h | `sys/dev/acpica/acpivar.h` | ヘッダー | acpi_SetInteger()のプロトタイプ |
| acpi.h | `sys/contrib/dev/acpica/include/acpi.h` | ヘッダー | ACPI型定義 |
| devctl.h | `sys/sys/devctl.h` | ヘッダー | devctl_notify()のプロトタイプ |
